/*
 * json_utils.cpp
 *
 *  
 */


#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MCAN_TCU_UTIL
#include "trcGenProj/Header/json_utils.cpp.trc.h"
#endif

#include "fc_mcan_tcu_AppMain.h"
#include "json_utils.h"


json_utils::json_utils()
{
	ETG_TRACE_USR1(("json_utils()"));
}
json_utils::~json_utils()
{
	ETG_TRACE_USR1(("~json_utils()"));
}
tBool json_utils::getJSONObject(Json::Value& input, tCString jsonObjName, Json::Value& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if (!value.isObject()) {
		ETG_TRACE_USR1(("%s is not an Object",jsonObjName));
		return FALSE;
	} else if(value == Json::Value::null){ // Cannot find JSONObject for wrong name.
		ETG_TRACE_USR1(("%s cannot be found",jsonObjName));
		return FALSE;
	} else {
		output = value;
		return TRUE;
	}
}

tBool json_utils::getJSONArray(Json::Value& input, tCString jsonObjName, Json::Value& output) {

	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR1(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isArray()) {
		ETG_TRACE_USR1(("%s is not an Array",jsonObjName));
		return FALSE;
	}
	else if (value.isArray()) {
		output = value;
		return TRUE;
	}

	return FALSE;
}

tBool json_utils::getString(Json::Value& input, tCString jsonObjName, std::string& output) {

	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR1(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isString()) {
		ETG_TRACE_USR1(("%s is not an String",jsonObjName));
		return FALSE;
	} else {
		bpstl::string temp = value.asCString();
		output = temp;
		return TRUE;
	}
}

tBool json_utils::gettBool(Json::Value& input, tCString jsonObjName, tBool& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR1(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isBool()) {
		ETG_TRACE_USR1(("%s is not a Bool",jsonObjName));
		return FALSE;
	} else {
		output = value.asBool();
		return TRUE;
	}
}

tBool json_utils::gettU8UInt(Json::Value& input, tCString jsonObjName, tU8& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR1(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR1(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU8) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU16UInt(Json::Value& input, tCString jsonObjName, tU16& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR1(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR1(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU16) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU32UInt(Json::Value& input, tCString jsonObjName, tU32& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR1(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR1(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU32) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU64UInt(Json::Value& input, tCString jsonObjName, tU64& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR1(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR1(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU64) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::getDouble(Json::Value& input, tCString jsonObjName, double& output){
    Json::Value value = input.get(jsonObjName, Json::Value::null);

    if (value == Json::Value::null){ // Cannot find JSONArray for wrong name.
        ETG_TRACE_USR1(("%s cannot be found", jsonObjName));
        return FALSE;
    }else if(!value.isInt() && !value.isDouble() ){
		ETG_TRACE_USR1(("%s is not an Integer or Double",jsonObjName));
		return FALSE;
    }
    else {
        output = (double) value.asDouble();
        ETG_TRACE_USR1(("Double: %lf", output));
        return TRUE;
    }
}
